<?php
/**
 * dwt listing functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package dwt listing
 */
add_action( "after_setup_theme", "dwt_listing_theme_setup" );
if ( ! function_exists( "dwt_listing_theme_setup" ) ) 
{
	/*dwt listing Theme Settings*/
	function dwt_listing_theme_setup() 
	{
		/* Theme Settings */
		require trailingslashit( get_template_directory () ) . "inc/theme_settings.php";
		/*Register Custom Navigation Walker*/
		require trailingslashit( get_template_directory () ) . "inc/nav.php";
		/* Load Essential Functions */
		require trailingslashit( get_template_directory () ) . "inc/theme-functions.php";
		/* Load Theme Functions */
		require trailingslashit( get_template_directory () ) . "inc/utilities.php";
		/* Load Theme Widgets */
		require trailingslashit( get_template_directory () ) . "inc/widgets.php";
		/* Theme Classes */
		require trailingslashit( get_template_directory () ) . "inc/classes/index.php";
		/* Theme Shortcodes */
		require trailingslashit( get_template_directory () ) . "inc/theme_shortcodes/shortcodes.php";
		/* Load Redux Options */
		require trailingslashit( get_template_directory () ) . "inc/options.php";
		/* Load Theme Widgets */
		require trailingslashit( get_template_directory () ) . "inc/listing-widgets.php";
		/* TGM */
		require trailingslashit( get_template_directory () ) . "tgm/tgm-init.php";
		
	}
}
/**
 * Register custom fonts.
 */
function dwt_listing_fonts_url($font_call = "" ) {
	$fonts_url = "";
	/*
	 * Translators: If there are characters in your language that are not
	 * supported by Libre Franklin, translate this to "off". Do not translate
	 * into your own language.	 
	 */
	if(is_rtl())
	{
		if($font_call == "xb-niloofar" ){ $font_families = "xb-niloofar"; }
		if($font_call == "droid-arabic-naskh" ){ $font_families = "droid-arabic-naskh"; }
		if($font_call == "popins"){$fonts_url = "https://fonts.googleapis.com/css?family=Open+Sans:400,600";}else{
		$fonts_url = "https://fontlibrary.org/face/".$font_families;
		}
	}
	else
	{
		$libre_franklin = _x( "on", "Libre Franklin font: on or off", "dwt-listing" );
		if ( "off" !== $libre_franklin )
		{
			$font_families = array();
	
			$font_families[] = "Open+Sans:400,600";
			$font_families[] = "Poppins:400,500,600";
			$font_families[] = "Mogra";
	
			$query_args = array(
				"family" => urlencode( implode( "|", $font_families ) ),
				"subset" => urlencode( "latin,latin-ext" ),
			);
	
			$fonts_url = add_query_arg( $query_args, "https://fonts.googleapis.com/css" );
		}
	}
	return esc_url_raw( $fonts_url );
}
/* ------------------------------------------------ */
/* Enqueue scripts and styles. */
/* ------------------------------------------------ */
add_action( "wp_enqueue_scripts", "dwt_listing_scripts" );
function dwt_listing_scripts()
{
	global $dwt_listing_options;
	$assets_dir = trailingslashit( get_template_directory_uri () ) . "assets/";
	/* Enqueue scripts. */
	wp_enqueue_script( "bootstrap", $assets_dir . "js/bootstrap.min.js", false, false, true );
	wp_enqueue_script( "dropzone", $assets_dir . "js/dropzone.js", false, false, true );
	wp_enqueue_script( "dwt-listing-plugins", $assets_dir . "js/plugins.js", false, false, true );
	wp_enqueue_script( "validator", $assets_dir . "js/validator.min.js", false, false, true );
	wp_enqueue_script( "dwt-listing-registration", $assets_dir . "js/registration.js", false, false, true );
	wp_enqueue_script( "dwt-listing-profile", $assets_dir . "js/profile.js", false, false, true );
	wp_enqueue_script( "dwt-listing-listing", $assets_dir . "js/listing.js", false, false, true );
	wp_enqueue_script( "jquery-confirm", $assets_dir . "js/jquery-confirm.js", false, false, true );
	wp_enqueue_script( "typeahead-adv", $assets_dir . "js/typeahead.adv.js", false, false, true );
	wp_enqueue_script( "leaflet",  $assets_dir . "js/map/leaflet.js", false, false, true );
	wp_enqueue_script( "leaflet-search",  $assets_dir . "js/map/leaflet-search.min.js", false, false, true );
	if(dwt_listing_text('dwt_listing_recaptcha') == 1)
	{
		wp_enqueue_script( 'recaptcha', '//www.google.com/recaptcha/api.js', false, false, true );
	}
	if($dwt_listing_options["dwt_listing_enable_map"] == "1"  && $dwt_listing_options["dwt_map_selection"] == "google_map"  && $dwt_listing_options["gmap_api_key"] != ""  )
	{
		$map_lang = "en";
		if( isset( $dwt_listing_options["dwt_listing_gmap_lang"] ) && $dwt_listing_options["dwt_listing_gmap_lang"] != ""  )
		{
			$map_lang	= $dwt_listing_options["dwt_listing_gmap_lang"];	
		}
		wp_enqueue_script( "google-map", "//maps.googleapis.com/maps/api/js?key=" . $dwt_listing_options["gmap_api_key"] ."&language=".$map_lang, false, false, true );
		//call back
		wp_register_script( "google-map-callback", "//maps.googleapis.com/maps/api/js?key=" . $dwt_listing_options["gmap_api_key"] . "&libraries=geometry,places&language=".$map_lang."&callback=" . "dwt_listing_location" , false, false, true );
	}
	if ( is_singular() ) wp_enqueue_script( "comment-reply" , "" , true ); 
	if( isset( $dwt_listing_options["dwt_listing_enable_video_option"] ) && $dwt_listing_options["dwt_listing_enable_video_option"] !="" )
	{
		wp_enqueue_style( "popup-video-iframe-style", $assets_dir . "css/video_player.css" );
		wp_enqueue_script( "popup-video-iframe", $assets_dir . "js/video_player.js", false, false, true );
	}
	wp_enqueue_script( "theia-sticky-sidebar",  $assets_dir . "js/theia-sticky-sidebar.js", false, false, true );
	wp_enqueue_script( "jquery-ui-sortable");
	wp_enqueue_script("imagesloaded");
	//only for search page
	if( isset( $dwt_listing_options["dwt_listing_seacrh_page"] ) && $dwt_listing_options["dwt_listing_seacrh_page"] != "" && is_page()  || is_tax(array('l_category','l_tags','l_location')))
	{
		if(get_page_template_slug( $dwt_listing_options["dwt_listing_seacrh_page"] ) == get_page_template_slug(get_the_ID()) || is_tax(array('l_category','l_tags','l_location')) )
		{
			//leaflet
			if(dwt_listing_text("dwt_listing_seacrh_layout") == "map")
			{
				wp_enqueue_script( "leaflet-loader",  $assets_dir . "js/map/leafloader.js", false, false, true );
				wp_enqueue_script( "leaflet-cluster",  $assets_dir . "js/map/leaflet.markercluster.js", false, false, true );
				wp_enqueue_script( "dwt-listing-search",  $assets_dir . "js/listing-search/search_map.js", false, false, true );
			}
			else if(dwt_listing_text("dwt_listing_seacrh_layout") == "topbar")
			{
				//for sidebar
				wp_enqueue_script( "dwt-listing-search",  $assets_dir . "js/listing-search/search_topbar.js", false, false, true );
			}
			else
			{
				//for sidebar
				wp_enqueue_script( "dwt-listing-search",  $assets_dir . "js/listing-search/search_sidebar.js", false, false, true );
			}
		}
	}
	
	if(is_page_template('page-events.php' ) && is_page()  || is_tax(array('l_event_cat','l_event_tags')) )
	{
		if(dwt_listing_text("dwt_listing_event_layout") == "map")
		{
			wp_enqueue_script( "leaflet-loader",  $assets_dir . "js/map/leafloader.js", false, false, true );
			wp_enqueue_script( "leaflet-cluster",  $assets_dir . "js/map/leaflet.markercluster.js", false, false, true );
			wp_enqueue_script( "dwt-listing-search",  $assets_dir . "js/event-search/events_map.js", false, false, true );
		}
		else
		{
			wp_enqueue_script( "dwt-listing-search",  $assets_dir . "js/event-search/events_simple.js", false, false, true );
		}
	}
	
	if(is_page_template('page-listing.php' ) && is_page())
	{
		wp_enqueue_script("jquery-ui-autocomplete");
		wp_enqueue_script( "date-en", $assets_dir . "js/submit-listing/date-en-US.js", array("jquery"), false, true );
		wp_enqueue_script( "timeselect", $assets_dir . "js/submit-listing/jquery.ui.timeselect.js", array("jquery"), false, true );
	}
	
	if( isset( $dwt_listing_options["dwt_listing_lp_style"] ) && $dwt_listing_options["dwt_listing_lp_style"] !="" && $dwt_listing_options["dwt_listing_lp_style"] =="minimal" && is_page_template('page-listing.php' ))
	{
		wp_enqueue_script( "bootstrap-fileinput", $assets_dir . "js/bootstrap-imageupload.min.js", array("jquery"), false, true );
	}
	wp_enqueue_script( "dwt-listing-custom", $assets_dir . "js/custom.js", array("jquery"), false, true );
	/* Load the stylesheets. */
	wp_enqueue_style( "dwt-listing-style", get_stylesheet_uri() );
	wp_enqueue_style( "bootstrap_min", $assets_dir . "css/bootstrap.min.css" );
	if ( is_rtl() )
	{
		wp_enqueue_style( "bootstrap-rtl", $assets_dir . "css/rtl/bootstrap-rtl.min.css" );
		wp_enqueue_style( "dwt-listing-mega-menu", $assets_dir . "css/rtl/mega-menu-rtl.css" );
	}
	else
	{
		wp_enqueue_style( "dwt-listing-mega-menu", $assets_dir . "css/mega-menu.css" );
	}
	wp_enqueue_style( "dwt_listing_plugins_styles", $assets_dir . "css/plugins.css" );
	if ( is_rtl() )
	{
		wp_enqueue_style( "dwt-listing-fonts-xb-niloofar", dwt_listing_fonts_url("xb-niloofar"),  array(), null );
		wp_enqueue_style( "dwt-listing-fonts-droid-arabic-naskh", dwt_listing_fonts_url("droid-arabic-naskh"),  array(), null );
		wp_enqueue_style( "dwt-listing-fonts-popins", dwt_listing_fonts_url("popins"),  array(), null );
		wp_enqueue_style( "dwt-listing-woo",  $assets_dir . "css/rtl/woocommerce-rtl.css" );
	}
	else
	{
		wp_enqueue_style( "dwt-listing-fonts", dwt_listing_fonts_url(),  array(), null );
		wp_enqueue_style( "dwt-listing-woo",  $assets_dir . "css/woocommerce.css" );
	}
	wp_enqueue_style( "dwt-listing-styling", $assets_dir . "css/dwt-listing.css" );
	if ( is_rtl() )
	{
		wp_enqueue_style( "leaflet", $assets_dir . "css/map/leaflet-rtl.css" );
		wp_enqueue_style( "dwt-listing-style-rtl", $assets_dir . "css/rtl/dwt-listing-rtl.css" );
		wp_enqueue_style( "dwt-listing-custom", $assets_dir . "css/rtl/custom-rtl.css" );
		wp_enqueue_style( "dwt-listing-responsive", $assets_dir . "css/rtl/responsive-rtl.css" );
	}
	else
	{
		wp_enqueue_style( "leaflet", $assets_dir . "css/map/leaflet.css" );
		wp_enqueue_style( "leaflet-search", $assets_dir . "css/map/leaflet-search.min.css" );
		wp_enqueue_style( "dwt-listing-custom", $assets_dir . "css/custom.css" );
		wp_enqueue_style( "dwt-listing-responsive", $assets_dir . "css/responsive.css" );
	}
	wp_enqueue_style( "dwt-listing-icons", $assets_dir . "css/all-icons.css" );
	wp_enqueue_style( "dwt-flat-icons", $assets_dir . "css/flaticons.css" );
}

function dwt_listing_custom_theme_setup() {
    add_theme_support( "html5", array( "comment-list" ) );
}
add_action( "after_setup_theme", "dwt_listing_custom_theme_setup" );


add_action( 'after_setup_theme', 'dwt_listing_hide_adminbar' );
if ( ! function_exists( 'dwt_listing_hide_adminbar' ) )
{
	function dwt_listing_hide_adminbar()
	{
		if ( is_user_logged_in() && !is_admin() &&  !( defined( 'DOING_AJAX' ) && DOING_AJAX ) )
		{
			$user = wp_get_current_user();
			if (in_array('subscriber',$user->roles))
			{
				// user has subscriber role
				show_admin_bar(false);
			}		
		}
	}
}