// JavaScript Document
jQuery(document).on("change keyup paste keydown","#mailchimp_api_key", function(e) {
		var val = jQuery(this).val();
		if( val !== "" )
			jQuery("#auth-mailchimp").removeAttr('disabled');
		else
			jQuery("#auth-mailchimp").attr('disabled','true');
});

jQuery(document).on( "click", "#auth-mailchimp", function(e){
	e.preventDefault();
	jQuery(".smile-absolute-loader").css('visibility','visible');
	var auth_token = jQuery("#mailchimp_api_key").val();
	var action = 'update_mailchimp_authentication';
	var data = {action:action,authentication_token:auth_token};
	jQuery.ajax({
		url: ajaxurl,
		data: data,
		type: 'POST',
		dataType: 'JSON',
		success: function(result){
			if(result.status == "success" ){
				jQuery(".bsf-cnlist-mailer-help").hide();
				jQuery("#save-btn").removeAttr('disabled');
				jQuery("#mailchimp_api_key").closest('.bsf-cnlist-form-row').hide();
				jQuery("#auth-mailchimp").closest('.bsf-cnlist-form-row').hide();
				jQuery(".mailchimp-list").html(result.message);
			} else {
				jQuery(".mailchimp-list").html('<span class="bsf-mailer-error">'+result.message+'</span>');
			}
			jQuery(".smile-absolute-loader").css('visibility','hidden');
		}
	});
	e.preventDefault();
});

jQuery(document).on( "click", "#disconnect-mailchimp", function(){
															
	if(confirm("Are you sure? If you disconnect, your previous campaigns syncing with mailchimp will be disconnected as well.")) {
		var action = 'disconnect_mailchimp';
		var data = {action:action};
		jQuery(".smile-absolute-loader").css('visibility','visible');
		jQuery.ajax({
			url: ajaxurl,
			data: data,
			type: 'POST',
			dataType: 'JSON',
			success: function(result){

				jQuery("#save-btn").attr('disabled','true');
				if(result.message == "disconnected" ){

					jQuery("#mailchimp_api_key").val('');
					jQuery(".mailchimp-list").html('');
					jQuery(".mailchimp-list-empty").closest('.bsf-cnlist-form-row').remove();
					jQuery("#disconnect-mailchimp").replaceWith('<button id="auth-mailchimp" class="button button-secondary auth-button" disabled="true">Authenticate MailChimp</button><span class="spinner" style="float: none;"></span>');
					jQuery("#auth-mailchimp").attr('disabled','true');

				}

				jQuery('.bsf-cnlist-form-row').fadeIn('300');
				jQuery(".bsf-cnlist-mailer-help").show();
				jQuery(".smile-absolute-loader").css('visibility','hidden');
			}
		});
	}
	else {
		return false;
	}
});

jQuery(document).on( "change click", "#smile_cn_group_display", function() {
	cp_display_group_dropdown();
});

jQuery(document).on( "change", "#mailchimp-list", function() {
	cp_display_group_dropdown();
});

function cp_display_group_dropdown(){
	var current_list = jQuery("#mailchimp-list").val();
	var list_count = 0;
	if( jQuery("#smile_cn_group_display").val() != 1 ) {
		jQuery(".bsf-cngroup-select").hide();
		jQuery(".cp-group-notice").hide();
		jQuery(".list-group").val('0');
	}else{
		var flag = 0;
		jQuery("#mailchimp-group > option").each(function() {
		    if( jQuery(this).data('list') == current_list ) {
		    	jQuery(this).show();

		    	// dont select more than one option
		    	if( jQuery(this).attr( "selected") !== 'selected' && flag == 0 ) {
		    		jQuery(this).attr( "selected", "selected" );
		    		flag = 1;
		    	}
		    	list_count++;
		    } else {
		    	jQuery(this).hide();
		    }
		});

		// if there are not groups available for the list
		if( list_count == 0 ) {
			jQuery(".cp-group-notice").show();
			jQuery("#mailchimp-group").attr('disabled','disabled').hide();
			jQuery(".list-group").val('0');
		} else {
			jQuery("#mailchimp-group").show().removeAttr('disabled');
			jQuery(".cp-group-notice").hide();
			jQuery(".list-group").val('1');
		}

	}
	jQuery("#mailchimp-group").find(":selected").removeAttr('selected');
	
}

jQuery(document).on( "change click", "#mailchimp-group", function() {
	cp_add_group_list();
});
function cp_add_group_list () {		
	if( typeof val == 'undefined' ){
		val = jQuery("#mailchimp-group").find(":selected").text();
	}	
	var val = jQuery("#mailchimp-group").val();
	jQuery("#mailchimp_group_id_list").val(val);	
}